/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.sms.ringtone;

import dinesh.io.BitInputStream;
import dinesh.io.BitOutputStream;
import dinesh.mobile.sms.ringtone.Constants;
import dinesh.mobile.sms.ringtone.PatternInstruction;
import java.io.IOException;

public class TempoInstruction
extends PatternInstruction
implements Constants {
    public static final int[] bpm_value = new int[]{25, 28, 31, 35, 40, 45, 50, 56, 63, 70, 80, 90, 100, 112, 125, 140, 160, 180, 200, 225, 250, 285, 320, 355, 400, 450, 500, 565, 635, 715, 800, 900};
    private int bpm;

    public TempoInstruction() {
        this.bpm = 8;
    }

    public TempoInstruction(String string) {
        this.bpm = 8;
        int n = Integer.parseInt(string.substring(1));
        for (int i = 0; i < bpm_value.length; ++i) {
            if (bpm_value[i] != n) continue;
            this.bpm = i;
            break;
        }
    }

    public TempoInstruction(BitInputStream bitInputStream) throws IOException {
        this.bpm = bitInputStream.read(5);
    }

    public TempoInstruction(int n) {
        this.bpm = n;
    }

    public int length() {
        return 8;
    }

    public void writeToStream(BitOutputStream bitOutputStream) throws Exception {
        bitOutputStream.write(this.getTypeID(), 3);
        bitOutputStream.write(this.bpm, 5);
    }

    public String print() {
        return "T" + bpm_value[this.bpm];
    }

    public int getTypeID() {
        return 4;
    }

    public int getBPM() {
        return this.bpm;
    }
}

